package com.example.bytesbee.alphabets.activities;

import static com.example.bytesbee.alphabets.activities.constants.IConstants.DEFAULT_DELAY;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ImageView;
import android.widget.TextView;

import com.daimajia.androidanimations.library.Techniques;
import com.daimajia.androidanimations.library.YoYo;
import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.utils.Utils;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class SplashActivity extends BaseActivity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.splash_activity);

        final Activity mActivity = this;

        final TextView mTxtName = findViewById(R.id.txtName);
        final ImageView imgView = findViewById(R.id.imgLogo);

//        final TextView mTxtVersionName = findViewById(R.id.txtVersionName);
//        mTxtVersionName.setText(Utils.getVersionName());
//        mTxtVersionName.setTypeface(Utils.getCustomFont(mActivity));

        mTxtName.setTypeface(Utils.getCustomFont(mActivity));

        YoYo.with(Techniques.ZoomInLeft).duration(1000).playOn(imgView);

        YoYo.with(Techniques.Shake).delay(500).duration(1500).playOn(mTxtName);

        final Handler handler = new Handler();

        handler.postDelayed(() -> {

            Intent intent = new Intent(getApplicationContext(), MainActivity.class);

            startActivity(intent);

            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);

            finish();

        }, DEFAULT_DELAY);
    }

}